package main

import (
	"flag"
	"fmt"
	"math/bits"
	"os"
	"strconv"
	"strings"
)

func parseOctets(input string) [4]byte {
	var octets [4]byte
	for i, octetStr := range strings.Split(input, ".") {
		octet, _ := strconv.Atoi(octetStr)
		if i < 4 {
			octets[i] = byte(octet)
		}
		//TODO: Fehlerbehandlung
	}
	return octets
}

func main() {
	var (
		ipaddr   [4]byte
		netmask  [4]byte
		netaddr  [4]byte
		cidr     bool
		bitcount int
	)

	flag.BoolVar(&cidr, "cidr", false, "output in cidr notation")
	flag.Usage = func() {
		fmt.Fprintf(flag.CommandLine.Output(), "Usage: %s [-cidr] <ipv4addr> <netmask>\n", os.Args[0])
		flag.PrintDefaults()
	}
	flag.Parse()

	if flag.NArg() != 2 {
		flag.Usage()
		os.Exit(1)
	}

	/*
		for i, value := range os.Args {
			fmt.Printf("%d: %s\n", i, value)
		}
	*/

	ipaddr = parseOctets(flag.Arg(0))
	netmask = parseOctets(flag.Arg(1))

	for i := range ipaddr {
		netaddr[i] = ipaddr[i] & netmask[i]
	}

	bitcount = bits.OnesCount8(netmask[0]) +
		bits.OnesCount8(netmask[1]) +
		bits.OnesCount8(netmask[2]) +
		bits.OnesCount8(netmask[3])

	fmt.Printf("IP address: %s\n", formatIP(ipaddr))
	fmt.Printf("netmask: %s\n", formatIP(netmask))
	fmt.Printf("net address: %s", formatIP(netaddr))
	if cidr {
		fmt.Printf("/%d\n", bitcount)
	} else {
		fmt.Println()
	}
}
