package main

import (
	"fmt"
	"os"
	"strconv"
	"strings"
)

func main() {
	if len(os.Args) != 3 {
		fmt.Fprintf(os.Stderr, "Usage: %s <ipv4addr> <netmask>", os.Args[0])
		os.Exit(1)
	}

	/*
		for i, value := range os.Args {
			fmt.Printf("%d: %s\n", i, value)
		}
	*/
	var (
		ipaddr  [4]byte
		netmask [4]byte
		netaddr [4]byte
	)

	for i, octetStr := range strings.Split(os.Args[1], ".") {
		octet, _ := strconv.Atoi(octetStr)
		if i < 4 {
			ipaddr[i] = byte(octet)
		}
		//TODO: Fehlerbehandlung
	}

	for i, octetStr := range strings.Split(os.Args[2], ".") {
		octet, _ := strconv.Atoi(octetStr)
		if i < 4 {
			netmask[i] = byte(octet)
		}
		//TODO: Fehlerbehandlung
	}

	for i := range ipaddr {
		netaddr[i] = ipaddr[i] & netmask[i]
	}

	fmt.Printf("IP address: %d.%d.%d.%d\n", ipaddr[0], ipaddr[1], ipaddr[2], ipaddr[3])
	fmt.Printf("netmask: %d.%d.%d.%d\n", netmask[0], netmask[1], netmask[2], netmask[3])
	fmt.Printf("net address: %d.%d.%d.%d\n", netaddr[0], netaddr[1], netaddr[2], netaddr[3])
}
