package main

import "fmt"

func ForEach(slice []int, fn func(int)) {
	for _, s := range slice {
		fn(s)
	}
}

func PrintIt(i int) {
	fmt.Println(i)
}

func Filter(ints []int, check func(int) bool) []int {
	var results = make([]int, 0, len(ints))
	for _, n := range ints {
		if check(n) == true {
			results = append(results, n)
		}
	}
	return results
}

func main() {
	var ints = []int{4, 5, 6, 7, 8, 4, 3}

	var filtered = Filter(ints, func(i int) bool { return i%2 == 0 })

	ForEach(ints, PrintIt)
	ForEach(ints, func(i int) {
		fmt.Print("[", i, "]")
	})
	fmt.Println(filtered)
}
