package main

import (
	"flag"
	"fmt"
	"os"
)

func main() {
	var (
		kmh float64
		mph float64
	)

	flag.Float64Var(&kmh, "kmh", 0.0, "km/h in mph umwandeln")
	flag.Float64Var(&mph, "mph", 0.0, "mph in km/h umwandeln")
	flag.Parse()

	if (kmh > 0.0 && mph > 0.0) || (kmh == 0.0 && mph == 0.0) {
		fmt.Fprintln(os.Stderr, "Bitte km/h ODER mph angeben")
		os.Exit(1)
	} else if kmh > 0.0 {
		fmt.Printf("%.2f km/h = %.2f mph\n", kmh, kmh/1.61)
	} else if mph > 0.0 {
		fmt.Printf("%.2f mph = %.2f km/h\n", mph, mph*1.61)
	}
}
