package main

import "fmt"

func main() {
	var (
		ipaddr  [4]byte = [...]byte{192, 168, 21, 66}
		netmask [4]byte = [...]byte{255, 255, 252, 0}
		netaddr [4]byte
	)

	/*
		netaddr = [4]byte{
			ipaddr[0] & netmask[0],
			ipaddr[1] & netmask[1],
			ipaddr[2] & netmask[2],
			ipaddr[3] & netmask[3],
		}
	*/
	for i := range ipaddr {
		netaddr[i] = ipaddr[i] & netmask[i]
	}

	fmt.Println("IP address", ipaddr)
	fmt.Println("netmask", netmask)
	fmt.Println("net address", netaddr)
}
