package main

import "fmt"

type Stack struct {
	top    int
	values [30]any
}

func (s *Stack) Push(value any) {
	if s.top < len(s.values)-1 {
		s.values[s.top] = value
		s.top++
	}
}

func (s *Stack) Pop() any {
	var value any
	if s.top > 0 {
		value = s.values[s.top-1]
		s.values[s.top-1] = nil
		s.top--
	}
	return value
}

func main() {
	var stack = Stack{}
	stack.Push(1)
	stack.Push(2)
	stack.Push("Hallo")
	stack.Push(445.8)
	fmt.Printf("%#v\n", stack)
	fmt.Println(stack.Pop())
	fmt.Println(stack.Pop())
	fmt.Printf("%#v\n", stack)

	var reverse Stack
	for _, ch := range "Hello World!" {
		reverse.Push(ch)
	}
	for ch := reverse.Pop(); ch != nil; ch = reverse.Pop() {
		fmt.Printf("%c", ch)
	}
}
