package main

import (
	"caesar/cipher"
	"flag"
	"fmt"
	"log"
	"os"
	"time"
)

func main() {
	var (
		verschiebefaktor int
		decode           bool
	)
	flag.IntVar(&verschiebefaktor, "rot", 13, "Buchstabenrotation (1-25)")
	flag.BoolVar(&decode, "decode", false, "Text entschlüsseln")
	flag.Parse()

	if flag.NArg() != 2 {
		flag.Usage()
		os.Exit(1)
	}

	var caesarCipher = cipher.New(verschiebefaktor)

	var outputText string
	if b, err := os.ReadFile(flag.Arg(0)); err == nil {
		var start = time.Now().UnixMilli()
		if decode {
			outputText = caesarCipher.Decode(string(b))
		} else {
			outputText = caesarCipher.Encode(string(b))
		}
		fmt.Printf("%dms\n", time.Now().UnixMilli()-start)
	} else {
		log.Fatal(err)
	}

	if err := os.WriteFile(flag.Arg(1), []byte(outputText), 0644); err != nil {
		log.Fatal(err)
	}
}
