// Variation von Bubblesort
// Komplexität: O(n²) im worst-case, O(n) im best case (wenn fast sortiert)
// Stabil
// In-Place
// Sortierung in zwei Richtungen
// iterativ

// Beginnt wie BubbleSort von links nach rechts (Größte Werte wandern nach rechts)
// Danach von rechts nach links (kleinste Werte nach links)
// Wiederholt sich, bis alles sortiert ist

package shakersort

func Sort(a []int) []int {
	anfang := 0
	ende := len(a) - 1
	swapped := true // swapped wird auf true gesetzt um die Schleife zu starten

	for swapped {
		swapped = false // Wenn die Schleife startet wird swapped auf false gesetzt und bleibt auf false wenn das array sortiert ist

		// Von links nach rechts (BubbleSort-Richtung)
		for i := anfang; i < ende; i++ { // Geht vom Anfang bis zum Ende das Array durch
			if a[i] > a[i+1] { // Falls die Zahl größer ist als die nächste wird getauscht
				a[i], a[i+1] = a[i+1], a[i] // Tauscht die zahlen miteinander
				swapped = true              // swapped wird bei Tausch auf True gesetzt, damit die Schleife weiterläuft
			}
		}

		if swapped == false {
			break // Falls kein Tausch mehr passiert, ist das Array sortiert
		}

		// Das gleiche nochmal nur von rechts nach links (kleinere Werte nach vorne)
		for i := ende; i > anfang; i-- {
			if a[i] < a[i-1] {
				a[i], a[i-1] = a[i-1], a[i]

			}
		}

	}

	return a
}
