package main

import "fmt"

/*
Celsius/Fahrenheit/Kelvin Umrechnung

Schreibe ein Programm, bei dem der Benutzer eine Temperatur in einer bestimmten
Einheit (Celsius, Fahrenheit oder Kelvin) eingeben kann und anschließend die
Temperatur in eine der anderen Einheiten umgerechnet angezeigt wird. Der Benutzer
soll beliebig viele Temperaturen umrechnen können ohne das Programm neu starten
zu müssen.

F = C × 1.8 + 32
C = (F - 32) ÷ 1.8
K = C + 273,15
*/

const cfdiff = 32

func main() {
	var (
		t float64
		q string
		z string
		e float64
	)

	for {
		fmt.Print("Temperatur: ")
		if _, err := fmt.Scan(&t); err != nil {
			fmt.Println(err)
			continue
		}
		fmt.Print("Angabe in Einheit (c/f/k): ")
		if _, err := fmt.Scan(&q); err != nil {
			fmt.Println(err)
			continue
		}
		fmt.Print("Umrechnen in Einheit (c/f/k): ")
		if _, err := fmt.Scan(&z); err != nil {
			fmt.Println(err)
			continue
		}

		switch {
		case q == "c" && z == "f":
			e = t*1.8 + cfdiff
		case q == "c" && z == "k":
			e = t + 273.15
		case q == "f" && z == "c":
			e = (t - cfdiff) / 1.8
		case q == "f" && z == "k":
			e = ((t - cfdiff) / 1.8) + 273.15
		case q == "k" && z == "c":
			e = t - 273.15
		case q == "k" && z == "f":
			e = (t-273.15)*1.8 + cfdiff
		}

		fmt.Printf("%.1f %s\n", e, z)
	}
}
