package main

import (
	"bufio"
	"errors"
	"fmt"
	"io/fs"
	"log"
	"os"
)

/*
Schreibe ein Programm, das eine Text-Datei öffnet und jede Zeile
der Datei mit der entsprechenden Zeilennummer am Anfang auf der
Konsole ausgibt.
*/
func main() {
	var (
		filename string
		scanner  *bufio.Scanner
	)

	if len(os.Args) < 2 {
		log.Fatal("missing filename")
	}

	filename = os.Args[1]

	if f, err := os.Open(filename); err != nil {
		if errors.Is(err, fs.ErrNotExist) {
			myerr := fmt.Errorf("Datei %s existiert nicht: %w", filename, err)
			log.Fatal(myerr)
		} else {
			log.Fatal(err)
		}
	} else {
		defer f.Close()
		scanner = bufio.NewScanner(f)
	}

	var line = 1
	for scanner.Scan() {
		fmt.Printf("%3d %s\n", line, scanner.Text())
		line++
	}
}
