package main

import (
	"fmt"
	"strings"
)

type Adresse struct {
	Strasse    string
	Hausnummer string
	PLZ        string
}

type Person struct {
	Vorname, Nachname string
	Adresse           Adresse
}

func inputPerson(person *Person) {

	fmt.Print("Vorname>")
	fmt.Scanln(&person.Vorname)
	fmt.Print("Nachname>")
	fmt.Scanln(&person.Nachname)
	fmt.Print("PLZ>")
	fmt.Scanln(&person.Adresse.PLZ)
}

func main() {
	var personen []Person

	/*
		var person = Person{
			Vorname:  "Jim",
			Nachname: "Test",
			Adresse: Adresse{
				Strasse:    "Frankenstr.",
				Hausnummer: "210",
				PLZ:        "90461",
			},
		}
	*/

	for {
		var cmd string
		fmt.Print(">")
		fmt.Scanln(&cmd)

		switch strings.ToLower(cmd) {
		case "print":
			var line30 = strings.Repeat("-", 30)
			fmt.Printf("|%-30s|%-30s|%-5s|\n", "Vorname", "Nachname", "PLZ")
			fmt.Printf("+%s+%s+%s+\n", line30, line30, strings.Repeat("-", 5))
			for _, p := range personen {
				fmt.Printf("|%-30s|%-30s|%5s|\n", p.Vorname, p.Nachname, p.Adresse.PLZ)
			}
		case "add":
			var person Person
			inputPerson(&person)

			personen = append(personen, person)
		case "exit":
			fmt.Println("Bye!")
			return
		}
	}
}
